<?php
require_once("../conexion.php");

$lugar    = $_GET['lugar']    ?? '';
$cantidad = $_GET['cantidad'] ?? '';
$dia      = $_GET['dia']      ?? '';
$tipo     = $_GET['tipo']     ?? '';
$persona     = $_GET['persona']     ?? '';
$total    = $_GET['total'] ?? '';

$query = "SELECT * FROM datos_sabadell WHERE 1=1";
$params = [];
$types = "";

if (!empty($lugar)) {
    $query .= " AND lugar LIKE ?";
    $params[] = "%$lugar%";
    $types .= "s";
}

if (!empty($cantidad)) {
    $query .= " AND cantidad = ?";
    $params[] = $cantidad;
    $types .= "i";
}

if (!empty($dia)) {
    $query .= " AND dia = ?";
    $params[] = $dia;
    $types .= "s";
}

if (!empty($tipo)) {
    $query .= " AND tipo LIKE ?";
    $params[] = "%$tipo%";
    $types .= "s";
}

if (!empty($persona)) {
    $query .= " AND persona LIKE ?";
    $params[] = "%$persona%";
    $types .= "s";
}

if (!empty($total)) {
    $query .= " AND total = ?";
    $params[] = $total;
    $types .= "i";
}

$stmt = $conexion->prepare($query);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

foreach ($result as $sabadell) { ?>
    <tr>
        <td><?= $sabadell['ID'] ?></td>
        <td><?= $sabadell['lugar'] ?></td>
        <td><?= $sabadell['cantidad'] ?></td>
        <td><?= $sabadell['dia'] ?></td>
        <td><?= $sabadell['tipo'] ?></td>
        <td><?= $sabadell['persona'] ?></td>
        <td><?= $sabadell['total'] ?>€</td>
        <td><button data-id="<?= $sabadell['ID'] ?>" id="actualizar" data-bs-toggle="modal" data-bs-target="#editarClientes" class='btn btn-warning'><i class="bi bi-pencil-square"></i></button>
            <button data-id="<?= $sabadell['ID'] ?>" class='btn btn-danger delete'><i class="bi bi-trash"></i></button>
        </td>
    </tr>
<?php }

$stmt->close();
