<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dinero revolut</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="stylesheet" href="assets/css/styles.css">
</head>

<body>
    <?php
    include("views/navbar.php");
    include("backend/conexion.php");

    $stmt = $conexion->prepare('SELECT * FROM tipo_pago WHERE 1=1');
    $stmt->execute();

    $pagos = $stmt->get_result();

    ?>

    <div class="content">

        <div class="row">
            <div class="col-12">
                <div class="input-group mb-4">
                    <input type="text" class="form-control" id="buscadorLugar" placeholder="Buscar lugar">
                    <input type="number" class="form-control" id="buscadorCantidad" placeholder="Buscar la cantidad en €">
                    <input type="date" class="form-control" id="buscadorDia" placeholder="Buscar dia">
                    <select id="buscadorTipo" class="form-control form-select">
                        <option value="" selected>Elige un tipo de pago</option>
                        <?php
                        foreach ($pagos as $pago) {
                            echo "<option value='$pago[tipo]'>$pago[tipo]</option>";
                        }
                        ?>
                    </select>
                    <input type="text" class="form-control" id="buscadorPersona" placeholder="Buscar persona">
                    <input type="number" class="form-control" id="buscadorTotal" placeholder="Buscar total">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalInsertar"><i class="bi bi-plus-circle-fill"></i></button>

                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped text-center align-middle">
                    <thead class="table-dark">
                        <th>ID</th>
                        <th>Motivo</th>
                        <th>Cantidad</th>
                        <th>Dia</th>
                        <th>Tipo</th>
                        <th>Persona</th>
                        <th>Total</th>
                        <th>Acciones</th>
                    </thead>
                    <tbody id="resultados"></tbody>

                </table>
            </div>

        </div>

        <!-- Añadir Dato Revolut MODAL -->
        <div class="modal fade" id="modalInsertar" tabindex="-1" aria-labelledby="modalInsertarLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalInsertarLabel">Añadir dato nuevo</h1>
                    </div>
                    <div class="modal-body">
                        <form id="insertarRevolut">
                            <label for="lugar">Motivo</label>
                            <input type="text" name="lugar" class="form-control" required>

                            <label for="cantidad">Cantidad</label>
                            <input type="number" name="cantidad" class="form-control" required>

                            <label for="dia">Día</label>
                            <input type="date" name="dia" class="form-control" required>

                            <label for="tipo">Tipo</label>
                            <select name="tipo" id="tipo" class="form-control form-select" required>
                                <option value="" selected>Elige un tipo de pago</option>
                                <?php
                                foreach ($pagos as $pago) {
                                    echo "<option value='$pago[tipo]'>$pago[tipo]</option>";
                                }
                                ?>
                            </select>

                            <label for="persona">Persona</label>
                            <input type="text" name="persona" class="form-control" required>

                            <label for="total">Total</label>
                            <input type="text" id="total" name="total" class="form-control" readonly>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" form="insertarRevolut" class="btn btn-primary" id="addRevolut">Añadir dato</button>
                    </div>
                </div>
            </div>
        </div>


        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
        <script src="assets/js/main.js"></script>

        <script>
            function buscarRevolut() {
                $.ajax({
                    type: "GET",
                    url: "backend/revolut/listar_revolut.php",
                    data: {
                        lugar: $("#buscadorLugar").val(),
                        cantidad: $("#buscadorCantidad").val(),
                        dia: $("#buscadorDia").val(),
                        tipo: $("#buscadorTipo").val(),
                        persona: $("#buscadorPersona").val(),
                        total: $("#buscadorTotal").val(),
                    },
                    success: function(r) {
                        $("#resultados").html(r);
                    },
                    error: function() {
                        alert("No se han podido cargar los datos correctamente");
                    }
                });
            }

            $(document).ready(function() {

                // Al abrir el modal → mostrar el total actual de la DB
                $('#modalInsertar').on('show.bs.modal', function() {
                    $.get("backend/revolut/get_total.php", function(data) {
                        $("#total").val(data);
                    });
                });

                // Calcular nuevo total cuando cambia cantidad o tipo
                $("input[name='cantidad'], #tipo").on("input change", function() {
                    let cantidad = parseFloat($("input[name='cantidad']").val()) || 0;
                    let tipo = $("#tipo").val();

                    $.get("backend/revolut/get_total.php", function(data) {
                        let totalActual = parseFloat(data) || 0;
                        let nuevoTotal = totalActual;

                        if (tipo === "recibido") {
                            nuevoTotal = totalActual + cantidad;
                        } else if (tipo === "pagado") {
                            nuevoTotal = totalActual - cantidad;
                        }

                        $("#total").val(nuevoTotal);
                    });
                });

                // Insertar
                $("#insertarRevolut").on("submit", function(e) {
                    e.preventDefault();
                    $.ajax({
                        type: "POST",
                        url: "backend/revolut/insertar_datos.php",
                        data: $(this).serialize(),
                        success: function(r) {
                            $("#respuesta").html(r);
                            buscarRevolut();
                        },
                        error: function() {
                            alert("No se ha podido añadir el dato de revolut");
                        }
                    });
                });

                // Eliminar
                $(document).on('click', '.delete', function() {
                    $.ajax({
                        type: "POST",
                        url: "backend/revolut/delete_datos.php",
                        data: {
                            id: $(this).data('id')
                        },
                        success: function(respuesta) {
                            buscarRevolut();
                            alert(respuesta);
                        },
                        error: function() {
                            alert("Error al eliminar el dato de revolut");
                        }
                    });
                });

                // Inicializar
                buscarRevolut();
                $("#buscadorLugar, #buscadorCantidad, #buscadorDia, #buscadorTipo, #buscadorPersona, #buscadorTotal").on("input change", buscarRevolut);
            });
        </script>

</body>
</html>
