<?php 
require_once "../conexion.php";

$lugar    = $_POST["lugar"]    ?? "";
$cantidad_raw = $_POST["cantidad"] ?? "";
$total_raw = $_POST["total"] ?? "";
$dia      = $_POST["dia"]      ?? "";
$tipo     = $_POST["tipo"]     ?? "";
$persona  = $_POST["persona"]  ?? "";

// Normalizar decimales: aceptar coma y punto, forzar 2 decimales
$cantidad = ($cantidad_raw === "" ? 0.00 : round(floatval(str_replace(',', '.', $cantidad_raw)), 2));
$total = ($total_raw === "" ? 0.00 : round(floatval(str_replace(',', '.', $total_raw)), 2));



if ($lugar == "") { ?>
    <script>
        alert("Complete el campo lugar para poder continuar");
    </script>
<?php die();
}
if ($cantidad_raw == "") { ?>
    <script>
        alert("Complete el campo cantidad para poder continuar");
    </script>
<?php die();
}
if ($dia == "") { ?>
    <script>
        alert("Complete el campo día para poder continuar");
    </script>
<?php die();
}
if ($tipo == "") { ?>
    <script>
        alert("Complete el campo tipo para poder continuar");
    </script>
<?php die();
}
if ($persona == "") { ?>
    <script>
        alert("Complete el campo persona para poder continuar");
    </script>
<?php die();
}
if ($total_raw == "") { ?>
    <script>
        alert("Complete el campo total para poder continuar");
    </script>
<?php die();
}

// 1. Obtener el total actual
$stmt = $conexion->prepare("SELECT total_numero FROM total WHERE id = 1");
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();
$totalActual = floatval($result['total_numero'] ?? 0);

// 2. Calcular nuevo total
if ($tipo === "recibido") {
    $nuevoTotal = round($totalActual + $cantidad, 2);
} elseif ($tipo === "pagado") {
    $nuevoTotal = round($totalActual - $cantidad, 2);
} else {
    $nuevoTotal = $totalActual;
}

// 3. Insertar en la tabla datos_revolut con el nuevo total
$stmt = $conexion->prepare("INSERT INTO datos_revolut(lugar, cantidad, dia, tipo, persona, total) VALUES (?, ?, ?, ?, ?, ?)");
$stmt->bind_param("sdsssd", $lugar, $cantidad, $dia, $tipo, $persona, $nuevoTotal);
$stmt->execute();

// 4. Actualizar la tabla total
$stmt = $conexion->prepare("UPDATE total SET total_numero = ? WHERE id = 1");
$stmt->bind_param("d", $nuevoTotal);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    echo "ok:Dato añadido con éxito. Nuevo total: $nuevoTotal";
} else {
    echo "error:No se ha podido añadir el dato";
}

$stmt->close();

?>