<?php
require_once("../conexion.php");

$lugar    = $_GET['lugar']    ?? '';
$cantidad = $_GET['cantidad'] ?? '';
$dia      = $_GET['dia']      ?? '';
$tipo     = $_GET['tipo']     ?? '';
$persona     = $_GET['persona']     ?? '';
$total    = $_GET['total'] ?? '';

$query = "SELECT * FROM datos_open_bank WHERE 1=1";
$params = [];
$types = "";

if (!empty($lugar)) {
    $query .= " AND lugar LIKE ?";
    $params[] = "%$lugar%";
    $types .= "s";
}

if (!empty($cantidad)) {
    $query .= " AND cantidad = ?";
    $params[] = $cantidad;
    $types .= "i";
}

if (!empty($dia)) {
    $query .= " AND dia = ?";
    $params[] = $dia;
    $types .= "s";
}

if (!empty($tipo)) {
    $query .= " AND tipo LIKE ?";
    $params[] = "%$tipo%";
    $types .= "s";
}

if (!empty($persona)) {
    $query .= " AND persona LIKE ?";
    $params[] = "%$persona%";
    $types .= "s";
}

if (!empty($total)) {
    $query .= " AND total = ?";
    $params[] = $total;
    $types .= "i";
}

$stmt = $conexion->prepare($query);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

foreach ($result as $open_bank) { ?>
    <tr>
        <td><?= $open_bank['ID'] ?></td>
        <td><?= $open_bank['lugar'] ?></td>
        <td><?= $open_bank['cantidad'] ?></td>
        <td><?= $open_bank['dia'] ?></td>
        <td><?= $open_bank['tipo'] ?></td>
        <td><?= $open_bank['persona'] ?></td>
        <td><?= $open_bank['total'] ?>€</td>
        <td><button data-id="<?= $open_bank['ID'] ?>" id="actualizar" data-bs-toggle="modal" data-bs-target="#editarClientes" class='btn btn-warning'><i class="bi bi-pencil-square"></i></button>
            <button data-id="<?= $open_bank['ID'] ?>" class='btn btn-danger delete'><i class="bi bi-trash"></i></button>
        </td>
    </tr>
<?php }

$stmt->close();
